using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;


namespace DS7000WPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        DS7000FormsControlLib.UsccFormsControl m_ds7000Ctrl;
        System.Windows.Forms.Integration.WindowsFormsHost m_host;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            CreateActiveXControl();
        }

        private void CreateActiveXControl()
        {
            // Create the interop host control.
            m_host =
                new System.Windows.Forms.Integration.WindowsFormsHost();

            // Create the ActiveX control.
            m_ds7000Ctrl = new DS7000FormsControlLib.UsccFormsControl();


            // Assign the ActiveX control as the host control's child.
            m_host.Child = m_ds7000Ctrl;

            // Add the interop host control to the Grid
            // control's collection of child controls.
            this.grid1.Children.Add(m_host);
            m_host.Width = this.Width;
            m_host.Height = this.Height - 120;

            m_ds7000Ctrl.UsccOcxPath = "D:\\Projects\\Perforce\\DS7000\\application_branch\\gui\\redist\\Debug";
            m_ds7000Ctrl.EnableActiveX(1);
        }

        private void btnDisposeActiveX_Click(object sender, RoutedEventArgs e)
        {
            this.grid1.Children.Remove(m_host);

            if (m_ds7000Ctrl != null)
            {
                m_ds7000Ctrl.close();
                m_ds7000Ctrl.EnableActiveX(0);
                m_ds7000Ctrl.Dispose();
                m_ds7000Ctrl = null;
            }

            if (m_host != null)
            {
                m_host.Dispose();
                m_host = null;
            }
        }

        private void btnCreateActiveX_Click(object sender, RoutedEventArgs e)
        {
            CreateActiveXControl();
        }

				private void TabItem_SizeChanged(object sender, SizeChangedEventArgs e)
				{
					
				}
    }
}
